<?php
/***
	Esta classe é responsável por controlar o banco de dados.
***/

class Banco_Dados{
	public $bd;
	public $consulta;
	
	const NORMAL = 0;
	const FETCH = 1;
	const FETCH_ALL = 2;
	const FETCH_COLUMN = 3;
	
	public function __construct($modo_sandbox){
        $appEnv = getenv('APP_ENV');

        if ($appEnv) {
            $appEnv = strtolower($appEnv);
        }

        $host_banco = $appEnv === 'dev' ? 'mysql8' : 'localhost';

		$nome_banco = $modo_sandbox ? 'pages_sistema_teste' : 'pages_sistema';
		$this->bd = new PDO('mysql:host='.$host_banco.';dbname='.$nome_banco.";charset=utf8mb4", 'pages_admin', 'win7?admin');
		$this->bd->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
		$this->bd->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	}
	
	// Função que retorna a ID da última execução do banco
	public function ultima_id(){
		return $this->bd->lastInsertId();
	}
	
	// Função que retorna a quantidade de dados encontrados
	public function quantidade(){
		return $this->consulta->rowCount();
	}
	
	// Executa uma consulta no banco
	public function executar($sql, $params = array(), $modo = self::NORMAL){
		$this->consulta = $this->bd->prepare($sql);
		$this->consulta->execute($params);
		if($modo == self::FETCH)
			return $this->get_resultado();
		else if($modo == self::FETCH_ALL)
			return $this->get_resultados();
		else if($modo == self::FETCH_COLUMN)
			return $this->get_coluna();
	}
	
	// Retorna um único resultado da última consulta
	public function get_resultado(){
		return $this->consulta->fetch();
	}
	
	// Retorna todos os resultados da última consulta
	public function get_resultados(){
		return $this->consulta->fetchAll();
	}

	// Retorna a coluna obtida na última consulta
	public function get_coluna(){
		return $this->consulta->fetchAll();
	}
}
?>