<?php
/***
	Esta classe é responsável por enviar os boletos do gerencianet
***/
require_once(__DIR__ . "/Sistema.php");
require_once(__DIR__ . "/Banco_Dados.php");
require_once(__DIR__ . "/Mascara.php");
require_once (__DIR__ . '/../../sistemawin7lib/vendor/autoload.php');
use Gerencianet\Exception\GerencianetException;
use Gerencianet\Gerencianet;

class Sistema_Gerencianet{
	private $producao_id = 'Client_Id_cbdb9558d8b7c827afdf4d2dca1ef5ef01dc432b';
	private $desenvolvimento_id = 'Client_Id_a9b13c8bdb7d6afa26d95aab54685d5290faadff';
	private $producao_secret = 'Client_Secret_2d22a9c041c1f39382fcb1648bb9e745799c4c3d';
	private $desenvolvimento_secret = 'Client_Secret_81aa487eb1a78256d9979a56d1aa0a183b511b46';
	public $sandbox;
	public $last_err;
	public $bd;
	public $transacao_id;
	private $api;

	function __construct($sandbox = true, $bd = null){
		$this->sandbox = $sandbox;
		if($bd == null)
			$this->bd = new Banco_Dados($sandbox);
		else
			$this->bd = $bd;
		$options = [
			'client_id' => $this->client_id(),
			'client_secret' => $this->client_secret(),
			'sandbox' => $this->sandbox
		];
		$this->api = new Gerencianet($options);
	}

	/* Retorna o Secret de cliente da API do gerencianet */
	private function client_secret(){
		if($this->sandbox == true)
			return $this->desenvolvimento_secret;
		else
			return $this->producao_secret;
	}

	/* Retorna a ID de cliente da API do gerencianet */
	private function client_id(){
		if($this->sandbox == true)
			return $this->desenvolvimento_id;
		else
			return $this->producao_id;
	}

	private function get_inner_html( $node ) {
	    $innerHTML= '';
	    $children = $node->childNodes;
	    foreach ($children as $child) {
	        $innerHTML .= $child->ownerDocument->saveXML( $child );
	    }
	    return $innerHTML;
	} 

	/* Retorna a cotação do dólar */
	function cotacao_dolar(){

		/* Valor do dolar Turismo sendo pego via API 
			O CODIGO FUNCIONA
			MAS ATIVAR QUANDO O SCRIPT ABAIXO DO INFOMONEY NAO FUNCIONAR
		 */
		
			try{
				
				$url = 'https://economia.awesomeapi.com.br/json/all/USDT-BRL'; 
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL,$url);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
				$return = curl_exec($ch);
				curl_close($ch);
				$obj = json_decode($return);
				return $obj->USDT->ask;

				// $json_file = file_get_contents("http://economia.awesomeapi.com.br/json/USDT");
				// $json_str = json_decode($json_file, true);
				// return $json_str[0]['ask'];

				// foreach ( $json_str as $e ){
				// 		/*
				// 				ask = Valor de Venda do Dolar Turismo
				// 				bid = Valor de Compra do Dolar Turismo
				// 		*/
				// 		return $e['ask'];
				// }

			}
			catch(Exception $e){
				$this->last_err = $e->getMessage();
				return 0;
			}

		// $cur_error = error_reporting(0);
		// if(!$fp=fopen("https://www.infomoney.com.br/mercados/cambio" ,"r" )) { 
		// 	return 0;
		// }
		// $html = "";
		// while(!feof($fp)) { $html .= fgets($fp); }
		// fclose($fp);
		// $dom = new DOMDocument();
		// $resultado = $dom->loadHTML($html);
		// error_reporting($cur_error);
		// if($resultado == false){
		// 	return 0;
		// }

		// $tabelas = $dom->getElementsByTagName("table");
		// $tabela_cotacoes = $tabelas->item(0);
		// $linhas = $tabela_cotacoes->getElementsByTagName("tbody");
		// $linhas = $tabela_cotacoes->getElementsByTagName("tr");
		// $achou_linha = false;
		// $linha_dolar_turismo = null;
		// for($i = 0; $i < $linhas->length; $i++){
		// 	$linha = $linhas->item($i);
		// 	$colunas = $linha->getElementsByTagName("td");
		// 	for($c = 0; $c < $colunas->length; $c++){
		// 		$coluna = $colunas->item($c);
		// 		$html_coluna = trim(get_inner_html($coluna));
		// 		if($html_coluna == "Dólar Turismo"){
		// 			$achou_linha = true;
		// 			break;
		// 		}
		// 	}
		// 	if($achou_linha == true){
		// 		$linha_dolar_turismo = $linha;
		// 		break;
		// 	}
		// }
		// if($achou_linha == true){
		// 	// $coluna = $linha_dolar_turismo->getElementsByTagName("td")->item(3)->getElementsByTagName("span")->item(0)->nodeValue;
		// 	$coluna = $linha_dolar_turismo->getElementsByTagName("td")->item(3)->nodeValue;
		// 	$cotacao = str_replace(",",".",$coluna);
		// 	if(is_numeric($cotacao)){
		// 		$cotacao = floatval($cotacao);
		// 		return $cotacao;
		// 	}
		// 	else{
		// 		return 0;
		// 	}
		// }
		// else{
		// 	return 0;
		// }
		// return 0;
	}

	/* Reenvia o boleto especificado */
	function reenviar_boleto($email, $vencimento, $id_transacao, $atualizar_vencimento){
		try{
			if($this->sandbox) $email = "desenvolvimento@grupolead.com.br";
			if($atualizar_vencimento){
				// Atualiza vencimento
				$params = [ 'id' => $id_transacao ];
				$body = [ 'expire_at' => $vencimento ];
				$charge = $this->api->updateBillet($params, $body);
			}
			
			// Reenvia o boleto
			$params = [ 'id' => $id_transacao ];
			$body = ['email' => $email ];
			$response = $this->api->resendBillet($params, $body);
			return true;
		}
		catch(Exception $e){
			$this->last_err = $e->getMessage();
			return false;
		}
	}

	/* Gera uma transação */
	function gerar_transacao($nome, $valor){
		try{
			$item_1 = [
				'name' => $nome,
				'amount' => 1,
				'value' => $valor
			];
			$items =  [ $item_1 ];
			$body  =  [ 'items' => $items ];
			
			$charge = $this->api->createCharge([], $body);
			return $charge;
		}
		catch(Exception $e){
			$this->last_err = $e->getMessage();
			return array();
		}
	}

	/*
	   Gera um boleto para uma pessoa física 
	   Retorna verdadeiro caso o boleto tenha sido gerado com sucesso.
	*/
	function gerar_boleto_pessoa_fisica($nome_produto, $valor_produto, $nome, $cpf, $telefone, $email, $vencimento, $mensagem){		
		try{
			if($this->sandbox) $email = "desenvolvimento@grupolead.com.br";
			// Primeiramente geramos a transação
			$transacao = $this->gerar_transacao($nome_produto, $valor_produto);
			if(empty($transacao)){ return false; }
			$charge_id = $transacao['data']['charge_id'];
			$this->transacao_id = $charge_id;
			
			$params = [
				'id' => $charge_id
			];
			
			$customer = [
				'name' => $nome,
				'cpf' => $cpf,
				'phone_number' => $telefone,
				'email' => $email
			];
			
			$bankingBillet = [
				'expire_at' => $vencimento,
				'customer' => $customer,
				'message' => $mensagem
			];
			
			$payment = [ 'banking_billet' => $bankingBillet ];
			$body = [ 'payment' => $payment ];

			$charge = $this->api->payCharge($params, $body);
			
			return true; // sucesso
		}
		catch(Exception $e){
			$this->last_err = $e->getMessage();
			return false;
		}
	}

	/*
	   Gera um boleto para uma pessoa jurídica
	   Retorna verdadeiro caso o boleto tenha sido gerado com sucesso.
	*/
	function gerar_boleto_pessoa_juridica($nome_produto, $valor_produto, $nome, $cnpj, $telefone, $email, $vencimento, $mensagem){
		try{
			if($this->sandbox) $email = "desenvolvimento@grupolead.com.br";
			// Primeiramente geramos a transação
			$transacao = $this->gerar_transacao($nome_produto, $valor_produto);
			if(empty($transacao)){ return false; }
			$charge_id = $transacao['data']['charge_id'];
			$this->transacao_id = $charge_id;
			
			$params = [
				'id' => $charge_id
			];
			
			$juridical_data = [
				'corporate_name' => $nome,
				'cnpj' => $cnpj
			];
			
			$customer = [
				'phone_number' => $telefone,
				'email' => $email,
				'juridical_person' => $juridical_data
			];
			
			$bankingBillet = [
				'expire_at' => $vencimento,
				'customer' => $customer,
				'message' => $mensagem
			];
			
			$payment = [ 'banking_billet' => $bankingBillet ];
			$body = [ 'payment' => $payment ];
			
			$charge = $this->api->payCharge($params, $body);
			
			return true; // sucesso
		}
		catch(Exception $e){
			$this->last_err = $e->getMessage();
			return false;
		}
	}

	/* Envia aos administradores uma mensagem de erro via email */
	function notificar_erro($msg){
		foreach(Sistema::email_adm("alan@grupolead.com.br") as $email){
			Sistema::enviar_email_sistema("<p>Houve um erro ao realizar envio do boleto de agendamento do G Suite. Detalhes do erro: <br><br>".$msg."</p>","Erro do Sistema Win7", $email, "Agência Win7");
		}
		
		$this->last_err = false;
	}

	/* Envia aos administradores uma notificação do sistema via email */
	function notificar($msg){
		$mensagem = '<html><head><style></style><title>Notificação</title></head><body><table align="center" width="600" style="padding: 50px 0px 50px 0px" cellpadding="25px"><tr valign="top" style="text-align: center; background-color: white;"><td style="padding-bottom:20px;"><a href="https://win7.com.br/"><img alt="Logo" style="display: block;" src="https://sistema.win7.com.br/adm/img/logo.png"></a></td></tr><tr valign="top" style="font-size:12px; color: #000; font-family: Tahoma, sans-serif;"><td style="padding-bottom:20px;">'.$msg.'</td></tr></table></body></html>';

		// Sistema::enviar_email($mensagem,"Notificação G Suite","desenvolvimento1@grupolead.com.br","Agência Win7");
		Sistema::enviar_email($mensagem,"Notificação G Suite","desenvolvimento@grupolead.com.br","Agência Win7");
		Sistema::enviar_email($mensagem,"Notificação G Suite","alan@grupolead.com.br","Agência Win7");
		Sistema::enviar_email($mensagem,"Notificação G Suite","financeiro@win7.com.br","Agência Win7");
	}

	/* Envia aos administradores um aviso de boleto gerado */
	function notificar_boleto($msg){
		// Sistema::enviar_email_sistema("<p>Boleto gerado: <br><br>".$msg."</p>","Envio de Boleto do G Suite","desenvolvimento1@grupolead.com.br","Agência Win7");
		Sistema::enviar_email_sistema("<p>Boleto gerado: <br><br>".$msg."</p>","Envio de Boleto do G Suite","desenvolvimento@grupolead.com.br","Agência Win7");
		Sistema::enviar_email_sistema("<p>Boleto gerado: <br><br>".$msg."</p>","Envio de Boleto do G Suite","alan@grupolead.com.br","Agência Win7");
		Sistema::enviar_email_sistema("<p>Boleto gerado: <br><br>".$msg."</p>","Envio de Boleto do G Suite","financeiro@win7.com.br","Agência Win7");
	}

	/* Faz a verificação completa de quais boletos devem ser enviados */
	function executar_rotina(){
		$log = '';
		$cotacao = $this->cotacao_dolar();
		if($cotacao <= 0 || $cotacao >= 10){
			$this->notificar_erro("Erro ao obter cotação do dólar");
			return;
		}

		/* Faz consulta de todos os agendamentos ativos */
		$dados = $this->bd->executar("SELECT * FROM TBL_GOOGLEAPPS WHERE ATIVADO = 1", array(), Banco_Dados::FETCH_ALL);
		
		/* Pega os dados da data de hoje */
		$ano_atual = date('Y');
		$mes_atual = date('m');
		$dia_atual = date('d');
		$current_time = time();
		
		foreach($dados as $agendamento){
			/* Pega os dados mais importante do agendamento*/
			$id = $agendamento['ID'];
			$cpf_cnpj = $agendamento['NU_CPF_CNPJ'];
			$tipo = $agendamento['TXT_TIPO'];
			$quantidade = $agendamento['NU_QUANTIDADE'];
			$nome = $agendamento['TXT_NOME'];
			$email = trim($agendamento['TXT_EMAIL']);
			$telefone = preg_replace("/[^0-9]/","",$agendamento['TXT_TELEFONE']);
			$ultima_execucao = $agendamento['DT_ULTIMA_EXECUCAO'];
			$ultima_id = $agendamento['TXT_ID_TRANSACAO'];
			$vencimento = $agendamento['DT_VENCIMENTO'];
			$vencimento = explode('/', $vencimento);
			$valor = $agendamento['NU_VALOR'];
			$moeda = $agendamento['TXT_MOEDA'];
			$taxa30mensal = $agendamento['NU_TAXA_TRINTA_MENSAL'];
			
			if ($moeda == "real") {
			
				// Aplica a taxa de 30% apenas em planos reais mensais
				if($tipo == "Mensal"){
					// Aplica 30% de taxa mensal se estiver ativado no sistema para esse cliente
					$valor *= $taxa30mensal == "1" ? 1.3 : 1; 
				}

				/* Monta os dados que serão utilizados */
				$real_formatado = number_format(floatval($valor) * floatval($quantidade) / 100,2,',','.');
				// $descricao = "G Suite - ".$quantidade." Conta(s) - ".$tipo." (Total: R$ ".$real_formatado.")";
				$descricao = "Google Workspace (G Suite) - ".$quantidade." Conta(s) - ".$tipo;
				// $mensagem = "Incluso imposto (6,8%) e R$ 3,14 do Gerencianet.";
				$mensagem = "";

				$tempo_execucao = strtotime($ultima_execucao);
				
				$valor = floatval($valor);
				$valor *= floatval($quantidade);
				// $valor *= $cotacao; // Aplica cotação do dólar
				// $valor *= 1.0638; // Adiciona IOF
				// $valor *= 1.0680; // Adiciona Impostos
				// $valor += 314; // Adiciona taxa de boleto do gerencianet
				$valor = number_format($valor / 100,2);
				$valor = preg_replace("/[^0-9]/","",$valor);
				$valor = intval($valor);
				$valor_str = "R$ ".number_format(floatval($valor) / 100,2,',','.');

			}else{
				/* Monta os dados que serão utilizados */
				$dolar_total = number_format(floatval($valor) * floatval($quantidade) / 100,2,',','.');
				// $descricao = "G Suite - ".$quantidade." Conta(s) - ".$tipo." (Total: U$ ".$dolar_total.")";
				$descricao = "Google Workspace (G Suite) - ".$quantidade." Conta(s) - ".$tipo;
				// $mensagem = "Incluso IOF (6,38%), imposto (6,8%) e R$ 3,14 do Gerencianet. Dólar tur. em ".date('d/m').": R$ " . number_format($cotacao,2,',','.') . ".";
				$mensagem = "";

				$tempo_execucao = strtotime($ultima_execucao);
				
				$valor = floatval($valor);
				$valor *= floatval($quantidade);
				$valor *= $cotacao; // Aplica cotação do dólar
				// $valor *= 1.0638; // Adiciona IOF
				// $valor *= 1.0680; // Adiciona Impostos
				// $valor += 314; // Adiciona taxa de boleto do gerencianet
				$valor = number_format($valor / 100,2);
				$valor = preg_replace("/[^0-9]/","",$valor);
				$valor = intval($valor);
				$valor_str = Mascara::converter_para_real($valor);
			}


			if($tipo == "Mensal"){
				$vencimento_humano = $vencimento[0] . "/" . $mes_atual . "/" . $ano_atual;
				$vencimento = $ano_atual."-".$mes_atual."-".$vencimento[0];
				$tempo_vencimento = strtotime($vencimento);
				
				$diferenca_execucao = $tempo_execucao - $tempo_vencimento;
				$diferenca_vencimento = $tempo_vencimento - $current_time;
				
				if($diferenca_execucao < 0 & $diferenca_vencimento > 0 & $diferenca_vencimento <= 60 * 60 * 24 * 10){
					$log .= "- Boleto gerado para ID ".$id." com vencimento para ".$vencimento_humano."<br>";

					$this->bd->executar("UPDATE TBL_GOOGLEAPPS SET DT_ULTIMA_EXECUCAO = :valor WHERE ID = :id", array(
						":valor" => $vencimento,
						":id" => $id
					));

					// Envia o boleto
					if(strlen($cpf_cnpj) == 11)
						$resultado = $this->gerar_boleto_pessoa_fisica($descricao, $valor, $nome, $cpf_cnpj, $telefone, $email, $vencimento, $mensagem);
					else
						$resultado = $this->gerar_boleto_pessoa_juridica($descricao, $valor, $nome, $cpf_cnpj, $telefone, $email, $vencimento, $mensagem);

					// Envia o email de sucesso/erro
					if($resultado == true){
						$this->notificar_boleto("<br>Nome: ".$nome."<br>CPF/CNPJ: ".$cpf_cnpj."<br>Vencimento: ".$vencimento_humano."<br>Valor: ".$valor_str);

						$this->bd->executar("UPDATE TBL_GOOGLEAPPS SET TXT_ID_TRANSACAO = :transacao WHERE ID = :id", array(
							":id" => $id,
							":transacao" => $this->transacao_id
						));
					}
					else{
						$this->notificar_erro($this->last_err."<br>Nome: ".$nome."<br>CPF/CNPJ: ".$cpf_cnpj."<br>Vencimento: ".$vencimento_humano);

						$this->bd->executar("UPDATE TBL_GOOGLEAPPS SET DT_ULTIMA_EXECUCAO = :valor, TXT_ID_TRANSACAO = :transacao WHERE ID = :id", array(
							":valor" => $ultima_execucao,
							":id" => $id,
							":transacao" => $ultima_id
						));
					}
				}
				else{
					$log .= "- Boleto não gerado para ID ".$id.". Motivo: ";
					if($diferenca_execucao >= 0){
						$log .= "boleto já gerado este mês.<br>";
					}
					else if($diferenca_vencimento <= 0){
						$log .= "<b>já passou da data de vencimento.</b><br>";
					}
					else{
						$log .= "vencimento está longe.<br>";
					}
				}
			}
			else{
				$vencimento_humano = $vencimento[0] . "/" . $vencimento[1] . "/" . $ano_atual;
				$vencimento = $ano_atual."-".$vencimento[1]."-".$vencimento[0];
				$tempo_vencimento = strtotime($vencimento);
				
				$diferenca_execucao = $tempo_execucao - $tempo_vencimento;
				$diferenca_vencimento = $tempo_vencimento - $current_time;
				
				if($diferenca_execucao < 0 & $diferenca_vencimento > 0 & $diferenca_vencimento <= 60 * 60 * 24 * 10){
					$log .= "- Boleto gerado para ID ".$id." com vencimento para ".$vencimento_humano."<br>";

					$this->bd->executar("UPDATE TBL_GOOGLEAPPS SET DT_ULTIMA_EXECUCAO = :valor WHERE ID = :id", array(
						":valor" => $vencimento,
						":id" => $id
					));
					
					// Envia o boleto
					if(strlen($cpf_cnpj) == 11)
						$resultado = $this->gerar_boleto_pessoa_fisica($descricao, $valor, $nome, $cpf_cnpj, $telefone, $email, $vencimento, $mensagem);
					else
						$resultado = $this->gerar_boleto_pessoa_juridica($descricao, $valor, $nome, $cpf_cnpj, $telefone, $email, $vencimento, $mensagem);

					// Envia o email de sucesso/erro
					if($resultado == true){
						$this->notificar_boleto("<br>Nome: ".$nome."<br>CPF/CNPJ: ".$cpf_cnpj."<br>Vencimento: ".$vencimento_humano."<br>Valor: ".$valor_str);

						$this->bd->executar("UPDATE TBL_GOOGLEAPPS SET TXT_ID_TRANSACAO = :transacao WHERE ID = :id", array(
							":id" => $id,
							":transacao" => $this->transacao_id
						));
					}
					else{
						$this->notificar_erro($this->last_err."<br>Nome: ".$nome."<br>CPF/CNPJ: ".$cpf_cnpj."<br>Vencimento: ".$vencimento_humano);

						$this->bd->executar("UPDATE TBL_GOOGLEAPPS SET DT_ULTIMA_EXECUCAO = :valor, TXT_ID_TRANSACAO = :transacao WHERE ID = :id", array(
							":valor" => $ultima_execucao,
							":id" => $id,
							":transacao" => $ultima_id
						));
					}
				}
			}
		}
		$this->notificar("Script de verificação dos boletos do google apps iniciada. Log de análise: <br><br>". $log);
	}
}
?>