<?php
/*
 * Este arquivo é responsável por retornar um json contendo o histórico
 * do indicador especificado.
 */

require_once(__DIR__ . "/../../classes/Sistema.php"); 
set_sistema(Sistema::INDICACOES);
$sistema = new Sistema(true, true);

if(empty($sistema->usuario->senha_transf)) $sistema->redirecionar("../senha-transferencia");

try {
	
	$rows = $sistema->indicacoes->obter_historico($sistema->usuario->id, "ALL_TIME", "", "");

	if ($rows == -1){
		echo "-2ID inválida!";
		exit;
	}
	$textoAlternativo = $sistema->indicacoes->text_cpf_cnpj_alternativo;

	echo json_encode([ 'texto_alternativo' => $textoAlternativo, 'dados' => $rows]);
	
}
catch (Exception $e) {
	echo "-2Houve um erro com o servidor";
	exit;
}
?>