<?php
/*
 * Este arquivo é responsável por atualizar a página de "Indicações" do sistema.
 * Para isso, ele faz uma pesquisa de todas as indicações do período,
 * emitindo um JSON ao final.
 */

require_once(__DIR__ . "/../../classes/Sistema.php"); 
set_sistema(Sistema::INDICACOES);
$sistema = new Sistema(true, true);

if(empty($sistema->usuario->senha_transf)) $sistema->redirecionar("../senha-transferencia");

// Verifica se a ID é um número
if($_POST['id'] != "-1" & !ctype_digit($_POST['id'])){
	echo "-2ID inválida!";
	exit;
}

// Verifica se a ID
if($_POST['id'] != "-1" & intval($_POST['id']) < 1){
	echo "-2ID inválida!";
	exit;
}

try {
	// Faz a pesquisa dos usuários
	$resultado = $sistema->indicacoes->obter_indicados_para_indicador($_POST['id'], $sistema->usuario->id);
	if($resultado == -1){
		echo "-2Não foi possível fazer a consulta";
		exit;
	}
	$geral = $sistema->indicacoes->obter_dados_gerais_indicador($sistema->usuario->id);
	$resultado[0]['saldo'] = $geral['saldo'];
	$resultado[0]['indicadosfechados'] = $geral['indicadosfechados'];
	$resultado[0]['indicados'] = $geral['indicados'];
	$resultado[0]['saldocadastro'] = $geral['saldocadastro'];
	echo json_encode_alt($resultado);
}
catch (Exception $e) {
	echo "-2Houve um erro com o servidor";
	exit;
}
?>