<?php
/*
 * Este arquivo é responsável por retornar um json contendo o histórico
 * do indicador especificado.
 */

require_once(__DIR__ . "/../../classes/Sistema.php"); 
set_sistema(Sistema::INDICACOES);
$sistema = new Sistema(true);

if(empty($sistema->usuario->senha_transf)) $sistema->redirecionar("../senha-transferencia");

if($sistema->indicacoes->usa_pontos != "1"){
	echo "-2Permissão Insuficiente";
	exit;
}

if(!ctype_digit($_POST['id'])){ // se a id não for um número retorna um erro
	echo "-2ID inválida!";
	exit;
}

try{
	$produto = $sistema->bd->executar("SELECT * FROM TBL_INDICACOES_PRODUTOS WHERE NU_ID = :id AND ID_CLIENTE_FK = :id2", array(
		":id" => $_POST['id'],
		":id2" => $sistema->indicacoes->id
	), Banco_Dados::FETCH);

	if($sistema->bd->quantidade() == 0){ // Os dados não foram encontrados, então a ID é inválida
		echo "-2ID inválida!";
		exit;
	}

	if((intval($produto['NU_ESTOQUE']) == 0 && $produto['NU_ESTOQUE_INFINITO'] == "0") || $produto['NU_DELETADO'] == "1"){
		echo "-2Produto Indisponível!";
		exit;
	}

	$dados = $sistema->indicacoes->obter_usuario($sistema->usuario->id);
	$saldo = intval($dados['TXT_SALDO']);
	$saldo_cadastro = intval($dados['TXT_SALDO_CADASTRO']);
	$pontos = intval($produto['NU_PONTOS']);
	$nome = $produto['TXT_NOME'];

	if($produto['NU_RESGATE_NORMAL'] == "1"){
		if($pontos > $saldo){
			echo "-2Saldo Insuficiente!";
			exit;
		}
	}
	else{
		if($pontos > ($saldo + $saldo_cadastro)){
			echo "-2Saldo Insuficiente!";
			exit;
		}
	}

	$sistema->indicacoes->resgatar_premio($sistema->usuario->id, $_POST['id']);

	$dados = $sistema->indicacoes->obter_usuario($sistema->usuario->id);
	$saldo = intval($dados['TXT_SALDO']);
	$saldo_cadastro = intval($dados['TXT_SALDO_CADASTRO']);
	$resultado = array(
		'pontos' => number_format($saldo, 0,",","."),
		'pontoscadastro' => number_format($saldo_cadastro, 0,",",".")
	);

	echo json_encode_alt($resultado);
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>