<?php
require_once(__DIR__ . "/../classes/Sistema.php");
set_sistema(Sistema::INDICACOES);
$sistema = new Sistema(true);

if(empty($sistema->usuario->senha_transf)) $sistema->redirecionar("senha-transferencia");

?>
<!DOCTYPE html>
<html>
<head>
<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-T9DQW4X');</script>
<!-- End Google Tag Manager -->
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<meta name='theme-color' content="<?php echo $sistema->indicacoes->cor2; ?>">
	<title>Painel Geral - <?php echo $sistema->indicacoes->nome; ?></title>
	<link rel="icon" type="image/ico" href="<?php echo $sistema->indicacoes->favicon; ?>" />
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<link rel="stylesheet" href="css/datatables.min.css"/>
	<link rel="stylesheet" href="css/bootstrap-xl-xxl.css">
	<link rel="stylesheet" href="css/font-awesome.min.css">
	<link rel="stylesheet" href="css/ionicons.min.css">
	<link rel="stylesheet" href="css/AdminLTE.min.css">
	<link rel="stylesheet" href="css/skin-blue-light.min.css">
	<link rel="stylesheet" href="css/custom1.0.0.css">
	<link rel="stylesheet" href="css/toastr.min.css">
	<link rel="stylesheet" href="css/bootstrap-datepicker.min.css">
	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
	<?php $sistema->layout->criar_meta_tags();?>
	<?php $sistema->layout->exibir_css_indicacao();?>
</head>

<body class="hold-transition skin-blue-light sidebar-mini <?php if($sistema->usuario->sidebar) {echo "sidebar-collapse"; }?>">
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-T9DQW4X"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
<div class="modal fade" id="modal-sistema"><div class="modal-dialog modal-lg"><div class="modal-content" id="modal-sistema-conteudo"></div></div></div>
<?php $sistema->layout->exibir_modal_adicionar_indicado();?>
<div class="wrapper">
	<?php $sistema->layout->exibir_cabecalho('home');?>

	<div class="content-wrapper">
		<!-- Content Header (Page header) -->
		<section class="content-header">
			<h1>
			Painel Geral
			<small>Visualize os dados principais de suas indicações</small>
			</h1>
			<ol class="breadcrumb">
				<li><a href="home"><i class="fa green-text fa-smile-o"></i> Painel Geral</a></li>
			</ol>
		</section>

		<section class="content container-fluid">
			<div class="row">
				<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
					<div class="info-box">
						<span class="info-box-icon bg-blue"><i class="fa fa-bars"></i></span>
						<div class="info-box-content">
							<span class="info-box-text"><?php echo $sistema->indicacoes->vocabulario[4]; ?></span>
							<span class="info-box-number" id="indicadosDados">0/0</span>
						</div>
					</div>
				</div>

				<?php if($sistema->usuario->saldo_cadastro > 0) { ?>
				<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
					<div class="info-box">
						<span class="info-box-icon text-green"><i class="fa fa-gift"></i></span>
						<div class="info-box-content">
							<span class="info-box-text"><?php echo $sistema->indicacoes->vocabulario[29]; ?></span>
							<span class="info-box-number" id="saldoCadastro">--</span>
						</div>
					</div>
				</div>
				<?php } ?>

				<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
					<div class="info-box">
						<span class="info-box-icon text-blue"><i class="fa fa-star"></i></span>
						<div class="info-box-content">
							<span class="info-box-text"><?php echo $sistema->indicacoes->vocabulario[5]; ?></span>
							<span class="info-box-number" id="valorTotal">--</span>
						</div>
					</div>
				</div>


				<div class="col-xs-12">
					<div class="box">
						<?php if($sistema->indicacoes->downlines == "1") {?>
						<div class="box-header with-border">
          					<div class="btn-group">
          						<a href= 'javascript:void(0);' class="disabled botao-home btn btn-default" onclick='home_historico();'><i class='fa fa-home botao-home'></i></a><a href= 'javascript:void(0);' class="disabled botao-voltar btn btn-default" onclick='voltar_historico();'><i class='fa fa-arrow-left botao-voltar'></i></a><a href= 'javascript:void(0);' class="disabled botao-avancar btn btn-default" onclick='avancar_historico();'><i class='fa 	fa-arrow-right botao-avancar'></i></a>
          					</div>
          					<span class="nomeIndicado">Indicados de <?php echo $sistema->usuario->nome; ?></span>
          				</div>
          				<?php } ?>
          				<div class="box-body">
          					<div id="tabelaIndicacoes" class="tabela">
          						<table id="tbIndicacoes" style="width: 100%;" class="table table-striped table-bordered dataTable no-footer cell-border nowrap responsive compact"></table>
          					</div>
          				</div>
          				<div class="overlay preloader">
							<i class="fa fa-refresh fa-spin"></i>
						</div>
          			</div>
				</div>
			</div>
		</section>
	</div>
	<?php $sistema->layout->exibir_rodape();?>
</div>

<script src="js/datatables.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/adminlte.min.js"></script>
<script src="js/toastr.min.js"></script>
<script src="js/moment.min.js"></script>
<script src="js/datetime-moment.js"></script>
<script src="js/date.js"></script>
<script src="js/geral1-2-1"></script>

</body>
</html>