<?php
/***
	Este arquivo exibe a tela de login padrão do sistema win7, 
	que é acessada por nossos clientes.
***/

require_once(__DIR__ . "/../classes/Sistema.php");
set_sistema(Sistema::INDICACOES);
$sistema = new Sistema(true);

if(!empty($sistema->usuario->senha_transf)) $sistema->redirecionar("./");
?>
<!DOCTYPE html>
<html>
<head>
<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-T9DQW4X');</script>
<!-- End Google Tag Manager -->
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<meta name='theme-color' content="<?php echo $sistema->indicacoes->cor2; ?>">
	<title>Senha de Transferência -  <?php echo $sistema->indicacoes->nome; ?></title>
	<link rel="icon" type="image/ico" href="<?php echo $sistema->indicacoes->favicon; ?>" />
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<link rel="stylesheet" href="css/font-awesome.min.css">
	<link rel="stylesheet" href="css/ionicons.min.css">
	<link rel="stylesheet" href="css/AdminLTE.min.css">
	<link rel="stylesheet" href="css/toastr.min.css">
	<link rel="stylesheet" href="css/custom-not-logged.css">
	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
	<?php $sistema->layout->exibir_css_indicacao_index();?>
</head>

<body class="hold-transition login-page" style="height: auto;">
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-T9DQW4X"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
	<div class="login-box">
		<div class="login-logo">
			<a href="./"><img src="<?php echo $sistema->indicacoes->logo; ?>" width="150"></a>
		</div>
		<div class="login-box-body">
			<?php if(isset($_SESSION['errosenhatransf'])) { ?>
			<div class="alert alert-danger alert-dismissible">
				<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
				<?php
				switch($_SESSION['errosenhatransf']){
					case 0:
						echo "Houve um erro ao conectar com o servidor! Atualize a página e tente novamente.";
						break;
					case 1:
						echo "Dados incorretos.";
						break;
				}
				?>
			</div>
			<?php unset($_SESSION['errosenhatransf']); } ?>
			<b>Para continuar usando o sistema, é necessário configurar sua senha de transferência.</b> <hr> A senha de transferência é utilizada para efetuar transferências de saldo e para resgatar seu bônus. Para criá-la, digite-a nos campos abaixo.<hr>
			<form action="action/salvar_senha_transferencia" method="post" onsubmit="return validarFormSenhaNova();">
				<div class="form-group has-feedback">
					<input id="senha1" name="senha1" type="password" class="form-control" alt="Senha" placeholder="Senha" required>
        			<span class="glyphicon glyphicon-lock form-control-feedback"></span>
				</div>
				<div class="form-group has-feedback">
					<input id="senha2" name="senha2" type="password" class="form-control" alt="Senha" placeholder="Redigite a Senha" required>
        			<span class="glyphicon glyphicon-lock form-control-feedback"></span>
				</div>
				<div class="row">
					<div class="col-xs-6">
						<a href="action/logout" style="vertical-align: sub;">Sair do Sistema</a>
					</div>
					<div class="col-xs-6">
						<button type="submit" class="btn btn-primary btn-block btn-flat">Enviar</button>
					</div>
				</div>
			</form>
		</div>
	</div>
	<script src="js/jquery.min.js"></script>
	<script src="js/bootstrap.min.js"></script>
	<script src="js/toastr.min.js"></script>
	<script src="js/basico-trocar-senha.js"></script>
</body>
</html>