$('.datepicker').datepicker({
	format: 'dd/mm/yyyy',
	endDate: '0d',
	autoclose: true,
	language: 'pt-BR'
});

$('.datepicker').mask('00/00/0000');

$.fn.dataTable.moment( 'DD/MM/YYYY HH:mm:ss');
$('#tabelaGrupos').html('<table id="tbGrupos" style="width: 100%;" class="table table-striped table-bordered dataTable no-footer cell-border nowrap responsive compact"></table>');
$('#tbGrupos').dataTable({
	"data": [],
	"order": [[ 2, 'desc' ]],
	"columns": [{ "title": "Nome do Grupo"},{ "title": "Qnt. Anúncios"},{ "title": "Acessos ao site"},{ "title": "% Acessos / Anúncios"},{ "title": "% em primeira Posição"},{ "title": "% entre os 4 primeiros"},{ "title": "Custo Por Clique"},{ "title": "Custo Total"},{ "title": "Opções"}],
	"lengthMenu": [[25, 50, 100, -1], ["25","50","100", "todas"]],
	"columnDefs": [{"targets": 7, "orderable": false}],
	responsive: true
});

function abrir_palavras(id, nome){
	if($('.dtr-bs-modal').hasClass("in")){
		$('.dtr-bs-modal').one('hidden.bs.modal', function () {
			abrir_palavras_2(id, nome);
		});
		$('.dtr-bs-modal').modal('hide');
	}
	else{
		abrir_palavras_2(id, nome);
	}
}

function abrir_palavras_2(id, nome){
	$(document).ready(function(){
		jQuery.ajax({
			type: "POST",
			url: "action/abrir_palavras",
			data: {'id' : id, 'nome' : nome},
			success: function(data){
				$('.preloader').css({display:"none"});
				if(data == '-1') {window.location.href = "./"; return;}
				if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
				if(data == '-3') {window.location.href = "./palavras"; return;}
				toastr.clear(); toastr.error(data.substring(2)); return;
			},
			beforeSend: function(){
				$('.preloader').css({display:"block"});
			},
			complete: function(){
				$('.preloader').css({display:"none"});
			},
			error: function(){
				$('.preloader').css({display:"none"});
				toastr.clear(); toastr.error("Houve um erro ao carregar as palavras-chave."); return;
			}
		});
	});
}

function abrir_termos_pesquisa(id, nome){
	if($('.dtr-bs-modal').hasClass("in")){
		$('.dtr-bs-modal').one('hidden.bs.modal', function () {
			abrir_termos_pesquisa_2(id, nome);
		});
		$('.dtr-bs-modal').modal('hide');
	}
	else{
		abrir_termos_pesquisa_2(id, nome);
	}
}

function abrir_termos_pesquisa_2(id, nome){
	$(document).ready(function(){
		jQuery.ajax({
			type: "POST",
			url: "action/abrir_termos_pesquisa",
			data: {'id' : id, 'nome' : nome},
			success: function(data){
				$('.preloader').css({display:"none"});
				if(data == '-1') {window.location.href = "./"; return;}
				if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
				if(data == '-3') {window.location.href = "./termos-pesquisa"; return;}
				toastr.clear(); toastr.error(data.substring(2)); return;
			},
			beforeSend: function(){
				$('.preloader').css({display:"block"});
			},
			complete: function(){
				$('.preloader').css({display:"none"});
			},
			error: function(){
				$('.preloader').css({display:"none"});
				toastr.clear(); toastr.error("Houve um erro ao carregar os termos de pesquisa."); return;
			}
		});
	});
}

function abrir_palavras_negativas(id, nome){
	if($('.dtr-bs-modal').hasClass("in")){
		$('.dtr-bs-modal').one('hidden.bs.modal', function () {
			abrir_palavras_negativas_2(id, nome);
		});
		$('.dtr-bs-modal').modal('hide');
	}
	else{
		abrir_palavras_negativas_2(id, nome);
	}
}

function abrir_palavras_negativas_2(id, nome){
	$(document).ready(function(){
		jQuery.ajax({
			type: "POST",
			url: "action/abrir_palavras_negativas",
			data: {'id' : id, 'nome' : nome},
			success: function(data){
				$('.preloader').css({display:"none"});
				if(data == '-1') {window.location.href = "./"; return;}
				if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
				if(data == '-3') {window.location.href = "./termos-pesquisa"; return;}
				toastr.clear(); toastr.error(data.substring(2)); return;
			},
			beforeSend: function(){
				$('.preloader').css({display:"block"});
			},
			complete: function(){
				$('.preloader').css({display:"none"});
			},
			error: function(){
				$('.preloader').css({display:"none"});
				toastr.clear(); toastr.error("Houve um erro ao carregar as palavras-chave negativas."); return;
			}
		});
	});
}

var ultimosDados = null;

function carregar_dados(){
	$(document).ready(function() {
		var dados = jQuery('#formGrupos').serialize();
		jQuery.ajax({
			type: "POST",
			url: "action/atualizar_grupos",
			data: dados,
			success: function(data){
				$('.preloader').css({display:"none"});
				if(data == '-1') {window.location.href = "./"; return;}
				if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
				var json = JSON.parse(data);
				var table_data = [];
				var dados;
				var colunas;
				var consultoria = json[0] == "1";
				ultimosDados = data;
				for (var i=1; i < json.length; i++){
					dados = json[i];
					var opcao = "<div class='btn-group'><a href= 'javascript:void(0);' onclick='abrir_palavras("+dados.adGroupID+", \""+dados.adGroup+"\");' class='btn btn-default text-orange' title='Clique para ver as palavras-chave.'><i class='fa fa-list'></i></a><a href= 'javascript:void(0);' onclick='abrir_termos_pesquisa("+dados.adGroupID+", \""+dados.adGroup+"\");' class='btn btn-default text-blue' title='Clique para ver os termos de pesquisa.'><i class='fa fa-search'></i></a><a href= 'javascript:void(0);' onclick='abrir_palavras_negativas("+dados.adGroupID+", \""+dados.adGroup+"\");' class='btn btn-default text-red' title='Clique para ver as palavras-chave negativas.'><i class='fa fa-list-ul'></i></a></div>";
					if(consultoria)
						table_data[i-1] = ["",dados.adGroup, dados.impressions, dados.clicks, dados.ctr, dados.imprAbsTop+"%", dados.imprTop+"%", dados.avgCPC, dados.cost,opcao];
					else
						table_data[i-1] = ["",dados.adGroup, dados.impressions, dados.clicks, dados.ctr, dados.imprAbsTop+"%", dados.imprTop+"%",opcao];
				}
				if(consultoria)
					colunas = [
						{},{ "title": "Nome do Grupo"},{ "title": "Qnt. Anúncios"},{ "title": "Acessos ao site"},{ "title": "% Acessos / Anúncios"},{ "title": "% em primeira Posição"},{ "title": "% entre os 4 primeiros"},{ "title": "Custo Por Clique"},{ "title": "Custo Total"},{ "title": "Opções", "className": "table-buttons"}
					];
				else
					colunas = [
						{},{ "title": "Nome do Grupo"},{ "title": "Qnt. Anúncios"},{ "title": "Acessos ao site"},{ "title": "% Acessos / Anúncios"},{ "title": "% em primeira Posição"},{ "title": "% entre os 4 primeiros"},{ "title": "Opções", "className": "table-buttons"}
					];
				var max_colunas = colunas.length - 1;
				$(document).ready(function() {
					$.fn.dataTable.moment( 'DD/MM/YYYY HH:mm:ss');
					$('#tabelaGrupos').html('<table id="tbGrupos" style="width: 100%;" class="table table-striped table-bordered dataTable no-footer cell-border nowrap responsive compact"></table>');
					if(json.length >= 2){
						$("#tbGrupos").append(
							$('<tfoot style="display: table-header-group;" />').append(`<tr>${colunas.map((i) => "<th></th>").join("")}</tr>`)
						);
						$('#tbGrupos tfoot tr th').each(function (index) {
							if(index !== 9){
								$(this).html('<input type="text" style="width: 100%" class="form-control" placeholder="" />');
							}
						});
					}
					$('#tbGrupos').dataTable({
						"data": table_data,
						"order": [[ 3, 'desc' ]],
						"columns": colunas,
						"language": {
							"decimal": ",",
    					"thousands": "."
						},
						"lengthMenu": [[25, 50, 100, -1], ["25","50","100", "todas"]],
						"columnDefs": [{"targets": colunas.length - 1, "orderable": false}, {className: 'control', orderable: false, targets: 0, width: "5%"}],
						initComplete: function () {
							// Apply the search
							//this.api()
							//	.columns([4,7])
							//	.every(function () {
							//		var column = this;
              //      var select = $('<select class="form-control"><option value=""></option></select>')
              //          .appendTo($(column.footer()).empty())
              //          .on('change', function () {
              //              var val = $.fn.dataTable.util.escapeRegex($(this).val());
              //              column.search(val ? '^' + val + '$' : '', true, false).draw();
              //          });
              //      column
              //          .data()
              //          .unique()
              //          .sort()
              //          .each(function (d, j) {
              //              select.append('<option value="' + d + '">' + d + '</option>');
              //          });
							//		var that = this;
							//		$('input', this.footer()).on('keyup change clear', function () {
							//			if (that.search() !== this.value) {
							//				that.search(this.value).draw();
							//			}
							//		});
							//		
							//	});
							this.api()
								.columns([0,1,2,3,4,5,6,7,8,9,10])
								.every(function () {
									var that = this;
									$('input', this.footer()).on('keyup change clear', function () {
										if (that.search() !== this.value) {
											that.search(this.value).draw();
										}
									});
								});
						},
						responsive: {
						    details: {
						    	type: 'column',
						        display: $.fn.dataTable.Responsive.display.modal( {
						            header: function ( row ) {
						                return '<span style="margin-right: 10px"><b>Dados do Grupo</b></span>';
						            }
						        } ),
						        renderer: function ( api, rowIdx, columns ) {
						        	text = "";
						        	text += columns[columns.length-1].data + "<br>";
						        	for(i = 0;i < columns.length;i++){
						        		column = columns[i];
						        		if(i == columns.length - 1) { continue; }
						        		if(i > 0) text += "<br>";
						        		text += "<b>" + column.title + ": </b>" + column.data;
						        	}
						        	return text;
						        }
						    }
						},
						"deferRender": true
					});
				});
			},
			beforeSend: function(){
				$('.preloader').css({display:"block"});
			},
			complete: function(){
				$('.preloader').css({display:"none"});
			},
			error: function(){
				$('.preloader').css({display:"none"});
				toastr.clear(); toastr.error("Houve um erro ao atualizar"); return;
			}
		});
	});
}

function atualizar(){
	var valor = $('#data').val();
	if(valor == "CUSTOM_DATE")
		$('.datadiv').removeClass("hide");
	else{
		$('.datadiv').addClass("hide");
		carregar_dados();
		salvarFiltro(valor,'','');
	}
}

function isJsonString(str) {
    try {
        JSON.parse(str);
    } catch (e) {
        return false;
    }
    return true;
}

function carregar_excel(){
	if(ultimosDados == null || isJsonString(ultimosDados) == false){
		$('.preloader').css({display:"none"});
		toastr.clear(); toastr.error("Não há dados para baixar."); return;
		return;
	}
	if($('.dtr-bs-modal').hasClass("in")){
		$('.dtr-bs-modal').one('hidden.bs.modal', function () {
			carregar_excel_2();
		});
		$('.dtr-bs-modal').modal('hide');
	}
	else{
		carregar_excel_2();
	}
}

function carregar_excel_2(){
	$(document).ready(function() {
		var formData = new FormData(document.getElementById('formGrupos'));
		formData.append("json", ultimosDados);
		jQuery.ajax({
			type: "POST",
			url: "action/baixar_grupos_validar",
			data: formData,
			success: function(data){
				$('.preloader').css({display:"none"});
				if(data == '-1') {window.location.href = "./"; return;}
				if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
				window.location.href = "./action/baixar_grupos";
			},
			beforeSend: function(){
				$('.preloader').css({display:"block"});
			},
			complete: function(){
				$('.preloader').css({display:"none"});
			},
			error: function(){
				$('.preloader').css({display:"none"});
				toastr.clear(); toastr.error("Houve um erro ao baixar."); return;
			},
			cache: false,
	        contentType: false,
	        processData: false
		});
	});
}

pegarFiltro(function(filtro,data1,data2){
	$('#data').val(filtro);
	$('#datainicial').val(data1);
	$('#datafinal').val(data2);
	if(filtro == "CUSTOM_DATE")
		$('.datadiv').removeClass("hide");
	carregar_dados();
});

$('#data, #switch').change(function(){ atualizar(); });
$('#datapersonalizada').click(function(){
	salvarFiltro($('#data').val(),$('#datainicial').val(),$('#datafinal').val());
	carregar_dados();
});