<?php

use Win7\App;

require_once(__DIR__ . "/classes/Sistema.php");
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true);
App::initialize();
$usarSistemaNovo = App::getConfig()->get('phone.usar_novo');

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às indicações
if($sistema->usuario->permissao_3cx == Usuario::PERM_NENHUMA) $sistema->redirecionar("home");
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-MFFM5J3');</script>
<!-- End Google Tag Manager -->
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<title>Win7 Fone - Sistema Win7</title>
	<link rel="icon" type="image/ico" href="favicon.png" />
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/bootstrap-select.min.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/datatables.min.css"/>
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/bootstrap-xl-xxl.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/font-awesome.min.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/ionicons.min.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/AdminLTE.min.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/skin-blue.min.css">
	<link rel="stylesheet" href="css/custom2.0.1.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/toastr.min.css">
	<link rel="stylesheet" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/bootstrap-datepicker.min.css">
	<link rel="stylesheet" type="text/css" href="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>css/jplayer.win7.css"  />

	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
	<?php $sistema->layout->criar_meta_tags();?>
</head>

<body class="hold-transition skin-blue sidebar-mini lte-fixed <?php if($sistema->usuario->sidebar) {echo "sidebar-collapse"; }?>">
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-MFFM5J3"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
<div class="modal fade" id="modal-sistema"><div class="modal-dialog modal-lg"><div class="modal-content" id="modal-sistema-conteudo"></div></div></div>
<div class="wrapper">
	<?php $sistema->layout->exibir_cabecalho('ligacoes');?>

	<div class="content-wrapper">
		<!-- Content Header (Page header) -->
		<section class="content-header">
			<h1>
			<span class="tipopesquisa">Win7 Fone</span>
			<small class="tipopesquisa2">Visualize suas ligações do Win7 Fone</small>
			</h1>
			<ol class="breadcrumb">
				<li><a href="javascript:void(0)"><i class="fa green-text fa-phone"></i> Win7 Fone</a></li>
				<li><a href="ligacoes">Histórico</a></li>
			</ol>
		</section>

		<section class="content container-fluid">
			<div class="row">
				<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
					<div class="info-box">
						<span class="info-box-icon bg-green"><i class="fa fa-bars"></i></span>
						<div class="info-box-content">
							<span class="info-box-text">Total de Ligações</span>
							<span class="info-box-number" id="totalligacoes"><div class="preloader"><i class="fa fa-refresh fa-spin"></i></div></span>
						</div>
					</div>
				</div>

				<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
					<div class="info-box">
						<span class="info-box-icon bg-blue"><i class="fa fa-dollar"></i></span>
						<div class="info-box-content">
							<span class="info-box-text">Total Gasto</span>
							<span class="info-box-number" id="totalgasto"><div class="preloader"><i class="fa fa-refresh fa-spin"></i></div></span>
						</div>
					</div>
				</div>

				<div class="col-xs-12">
          			<div class="box">
          				<div class="box-body">
          					<form action="" method="POST" id="formLigacoes">
	          					<div class="row">
	          						<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
	          							<div class="form-group">
		          							<label>Período:</label>
											<select name="data" id="data" class="form-control" title="Selecione um perído">
												<?php $sistema->layout->select_periodo(); ?>
											</select>
										</div>
	          						</div>
	          						<div class="<?php if($sistema->filtro->valor() != "CUSTOM_DATE") { echo "hide"; } ?> datadiv">
	          							<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
		          							<div class="form-group">
												<label>Data Inicial:</label>
												<div class="input-group date">
													<div class="input-group-addon">
														<i class="fa fa-calendar"></i>
													</div>
													<input type="text" class="form-control pull-right datepicker" name="datainicial" id="datainicial" value="<?php echo $sistema->filtro->data_inicio(); ?>">
												</div>
											</div>
										</div>
										<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
											<div class="form-group">
												<label>Data Final:</label>
												<div class="input-group date">
													<div class="input-group-addon">
														<i class="fa fa-calendar"></i>
													</div>
													<input type="text" class="form-control pull-right datepicker" class="datepicker" name="datafinal" id="datafinal" value="<?php echo $sistema->filtro->data_fim(); ?>">
												</div>
											</div>
										</div>
										<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
											<a id="datapersonalizada" class="btn btn-block btn-primary btn-flat">Pesquisar</a>
										</div>
									</div>
	          					</div>
          					</form>
          				</div>
          				<div class="overlay preloader filtros">
							<i class="fa fa-refresh fa-spin"></i>
						</div>
          			</div>
          		</div>
			</div>
			<div class="row">
				<div class="col-xs-12">
					<div class="box">
          				<div class="box-body">
          					<div id="tabelaLigacoes" class="tabela">
          						<table id="tbLigacoes" style="width: 100%;" class="table table-striped table-bordered dataTable no-footer cell-border nowrap responsive compact"></table>
          					</div>
          				</div>
          				<div class="overlay preloader">
							<i class="fa fa-refresh fa-spin"></i>
						</div>
          			</div>
				</div>
			</div>
		</section>
	</div>
	<?php $sistema->layout->exibir_rodape();?>
</div>

<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/jquery.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/datatables.min.js?v=<?=App::VERSION?>"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/bootstrap.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/bootstrap-select.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/adminlte.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/bootstrap-datepicker.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/bootstrap-datepicker.pt-BR.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/toastr.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/jquery.mask.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/moment.min.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/datetime-moment.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/date.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/filtros.js"></script>
<script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/jquery.jplayer.min.js"></script>
<?php if($usarSistemaNovo):?>
    <script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/main.js?v=<?=App::VERSION?>"></script>
    <script src="<?php if ($sistema->usuario instanceof Usuario_Adm) echo "../"; ?>js/ligacoes-novo.js?v=<?=App::VERSION?>"></script>
<?php else:?>
    <script src="js/ligacoes2-1-0"></script>
<?php endif;?>

</body>
</html>