<?php

namespace Win7\Ads\Report;

/**
 * Utilitário que monta parcelas de uma query.
 *
 * @author Thiago Daher
 */
class QueryExpressionBuilder
{

    /**
     * @param string $field
     * @param array $list
     * @return string
     */
    public function in(string $field, array $list): string
    {
        return $this->buildIn($field, $list, true);
    }

    /**
     * @param string $field
     * @param array $list
     * @param bool $positive
     * @return string
     */
    private function buildIn(string $field, array $list, bool $positive): string
    {
        $term    = $positive ? 'IN' : 'NOT IN';
        $result  = $field . " $term (";
        $counter = 0;

        foreach ($list as $element) {
            if ($counter > 0) {
                $result .= ', ';
            }
            $result .= "'$element'";
            $counter++;
        }

        $result .= ')';

        return $result;
    }

    /**
     * @param string $field
     * @param array $list
     * @return string
     */
    public function notIn(string $field, array $list): string
    {
        return $this->buildIn($field, $list, false);
    }
}