<?php

namespace Win7\Ads\Repository;

use Win7\Ads\Entity\CustomerFilter;
use Win7\Ads\Report\ReportRequest;

/**
 * Repositório responsável por consultar e executar modificações em palavras-chave.
 *
 * @author Thiago Daher
 */
class KeywordViewRepository extends AdsRepository
{

    /**
     * Retorna a lista de palavras-chave, juntamente com as métricas.
     *
     * @param \Win7\Ads\Entity\CustomerFilter $filter
     * @param string|null $adGroup
     * @return array
     */
    public function getListWithMetrics(CustomerFilter $filter, ?string $adGroup): array
    {
        $request = new ReportRequest();
        $request->setCustomerId($filter->getCustomerId());

        $qb = $request->getQueryBuilder();
        $qb->andSelect('ad_group_criterion.keyword.text');
        $qb->andSelect('metrics.conversions_from_interactions_rate');
        $qb->andSelect('metrics.clicks');
        $qb->andSelect('metrics.impressions');
        $qb->andSelect('metrics.conversions');
        $qb->andSelect('metrics.ctr');
        $qb->andSelect('ad_group.id');
        $qb->andSelect('ad_group.name');
        $qb->andSelect('campaign.name');
        $qb->andSelect('metrics.absolute_top_impression_percentage');
        $qb->andSelect('metrics.top_impression_percentage');
        $qb->andSelect('metrics.average_cpc');
        $qb->andSelect('metrics.cost_micros');
        $this->applyCampaignFilter($qb, $filter);
        $this->applyDateFilter($qb, $filter);
        $qb->andWhere("ad_group_criterion.status = 'ENABLED'");

        if ($adGroup) {
            $qb->andWhere("ad_group.id = '$adGroup'");
        }

        $qb->andWhere('metrics.impressions > 0');
        $qb->andWhere('metrics.clicks > 0');
        $qb->from('keyword_view');

        return $this->getReportResult($request);
    }

    /**
     * Retorna a lista de palavras-chave negativas, em nível de grupo de anúncios.
     *
     * @param \Win7\Ads\Entity\CustomerFilter $filter
     * @param string|null $adGroup
     * @return array
     */
    public function getNegativeList(CustomerFilter $filter, ?string $adGroup): array
    {
        $request = new ReportRequest();
        $request->setCustomerId($filter->getCustomerId());

        $qb = $request->getQueryBuilder();
        $qb->andSelect('campaign.name');
        $qb->andSelect('ad_group_criterion.keyword.text');
        $qb->andSelect('ad_group_criterion.keyword.match_type');
        $qb->andSelect('ad_group_criterion.negative');
        $qb->andSelect('ad_group.name');
        $this->applyCampaignFilter($qb, $filter);
        $this->applyDateFilter($qb, $filter);
        $qb->andWhere($qb->expr()->in('campaign.status', ['ENABLED', 'PAUSED']));
        $qb->andWhere($qb->expr()->in('ad_group_criterion.status', ['ENABLED', 'PAUSED']));
        $qb->andWhere('ad_group_criterion.negative = true');

        if ($adGroup) {
            $qb->andWhere("ad_group.id = '$adGroup'");
        }

        $qb->from('keyword_view');

        return $this->getReportResult($request);
    }
}