<?php

namespace Win7;

use DI\Container;
use DI\ContainerBuilder;
use RuntimeException;

/**
 * @author Thiago Daher
 */
final class App
{

    /**
     * @var \DI\Container
     */
    private static $container;

    /**
     * @var \Win7\Config
     */
    private static $config;

    /**
     * @var bool
     */
    private static $initialized = false;

    /**
     * @return \DI\Container
     */
    public static function getContainer(): Container
    {
        return self::$container;
    }

    /**
     * @return void
     * @throws \Exception
     */
    public static function initialize()
    {
        if (self::$initialized) {
            return;
        }

        self::$initialized = true;
        self::defineConstants();
        self::$config = new Config(self::loadArrayFile(CONFIG_PATH . 'default.php'));
        self::initContainer();
    }

    /**
     * @return void
     */
    private static function defineConstants()
    {
        define('CONFIG_PATH', realpath(__DIR__ . '/../config/') . '/');
    }

    /**
     * @param string $path
     * @return array
     */
    private static function loadArrayFile(string $path): array
    {
        $result = self::loadFile($path);

        if (!is_array($result)) {
            throw new RuntimeException("The file " . basename($path) . ' is not an configuration file!');
        }

        return $result;
    }

    /**
     * @param string $path
     * @return mixed|array|callable
     */
    private static function loadFile(string $path)
    {
        if (!file_exists($path)) {
            throw new RuntimeException("The file " . basename($path) . ' does not exist!');
        }

        return require $path;
    }

    /**
     * @return void
     * @throws \Exception
     */
    private static function initContainer()
    {
        $builder = new ContainerBuilder();
        $builder->useAnnotations(true);
        $builder->addDefinitions(self::loadArrayFile(CONFIG_PATH . 'dependencies.php'));
        self::$container = $builder->build();
    }

    /**
     * @return \Win7\Config
     */
    public static function getConfig(): Config
    {
        return self::$config;
    }
}