<?php

namespace Win7\Ads\Utils;

/**
 * Utilirário para montar string com o nome de recursos e entidades
 * do Google Ads.
 *
 * @author Thiago Daher
 */
final class ResourceNames
{

    /**
     * Retorna o nome completo da campanha.
     *
     * @param string $customerId
     * @param string $campaignId
     * @return string
     */
    public static function forCampaign(string $customerId, string $campaignId): string
    {
        return sprintf(
            'customers/%s/campaigns/%s',
            $customerId,
            $campaignId
        );
    }
}